#ifndef __FACULTY_H
#define __FACULTY_H

#include "atomic.h"

class Faculty : public Atomic

{
public :
	Faculty ( const string &name = "Faculty" );

	virtual string className() const ;

protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction ( const InternalMessage & );

private:
	const Port &applicationCourseCheck;
	Port &facultyOUT;
	Port &advisorOpinionOUT;
	Time facultyTime;
	int checkNum;
	int checkFacultyNum;
	bool qualify;

};

inline string Faculty::className() const
{
	return "Faculty";
}

#endif
